/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.utils.mapui;

import filenet.vw.api.VWAttachment;
import filenet.vw.api.VWAttachmentType;
import filenet.vw.api.VWFieldDefinition;
import filenet.vw.api.VWFieldType;
import filenet.vw.api.VWLibraryType;
import filenet.vw.api.VWMapDefinition;
import filenet.vw.api.VWMergeType;
import filenet.vw.api.VWMilestoneDefinition;
import filenet.vw.api.VWParticipant;
import filenet.vw.api.VWPartnerLinkDefinition;
import filenet.vw.api.VWRuleSetDefinition;
import filenet.vw.api.VWSchema;
import filenet.vw.api.VWWorkflowDefinition;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.images.VWImageLoader;
import filenet.vw.toolkit.utils.mapui.VWMapCache;
import filenet.vw.toolkit.utils.mapui.VWPrintableProperty;
import filenet.vw.toolkit.utils.resources.VWResource;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class VWPrintableWFProperty
extends VWPrintableProperty {
    protected static final Image WF_ICON = VWImageLoader.createImageIcon("wf_print.gif").getImage();
    protected static final int FIELD_NAME_COLUMN_SZ = 31;
    protected static final int FIELD_TYPE_COLUMN_SZ = 15;
    protected static final int FIELD_VALUE_COLUMN_SZ = 30;
    private VWWorkflowDefinition m_wfDefinition = null;
    private VWFieldDefinition[] m_fields = null;
    private VWMilestoneDefinition[] m_milestones = null;
    private VWMapDefinition[] m_maps = null;
    private VWMapCache m_mapCache = null;
    private boolean m_bPrintAllInfo = true;

    public VWPrintableWFProperty(VWMapCache mapCache, VWWorkflowDefinition wf, Graphics g, boolean bPrintAll) {
        super(g);
        this.m_wfDefinition = wf;
        this.m_mapCache = mapCache;
        this.m_bPrintAllInfo = bPrintAll;
        this.init();
    }

    protected void repaginate(PageFormat pf) {
        try {
            this.m_ImageableHeight = (int)pf.getImageableHeight();
            this.m_ImageableWidth = (int)pf.getImageableWidth();
            this.newChapter(VWResource.s_workflowProperties);
            this.appendTitleLine(VWResource.s_workflowProperties);
            this.printGeneralInfo();
            if (this.m_bPrintAllInfo) {
                this.printFieldsInfo();
                this.printAttachmentsInfo();
                this.printWorkflowGroupInfo();
                this.printMilestoneInfo();
                this.printSubMapInfo();
                this.printWebServicesInfo();
            }
            this.flushLastPage();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected void renderPage(Graphics2D g2, PageFormat pf, int idx) throws PrinterException {
        Point p = new Point(0, 0);
        ArrayList page = this.getPage(idx - this.m_startingPage);
        for (String line : page) {
            if (line.equals(VWResource.s_workflowProperties)) {
                this.printTitleLine(WF_ICON, VWResource.s_workflowProperties, p);
                continue;
            }
            if (line.startsWith("[[FOOTER]]")) {
                String footer = line.substring("[[FOOTER]]".length());
                this.printFooterLine(footer);
                continue;
            }
            this.printTextLine(line, p);
        }
    }

    private void init() {
        try {
            this.m_fields = this.m_wfDefinition.getFields();
            this.m_milestones = this.m_wfDefinition.getMilestones();
            this.m_maps = this.m_mapCache.getMapDefinitions();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void printGeneralInfo() throws Exception {
        String textStr = null;
        if (this.m_bPrintAllInfo) {
            textStr = this.m_wfDefinition.getBaseWorkClassName();
            if (textStr == null || textStr.length() < 1) {
                this.appendTextLine(VWResource.s_colon.toString(VWResource.s_baseWorkflow) + VWResource.s_none, 0, false);
            } else {
                this.appendTextLine(VWResource.s_colon.toString(VWResource.s_baseWorkflow) + textStr, 0, false);
            }
        }
        if ((textStr = this.m_wfDefinition.getName()) == null || textStr.length() < 1) {
            this.appendTextLine(VWResource.s_colon.toString(VWResource.s_name) + VWResource.s_none, 0, false);
        } else {
            this.appendTextLine(VWResource.s_colon.toString(VWResource.s_name) + textStr, 0, false);
        }
        if (this.m_bPrintAllInfo) {
            textStr = this.m_wfDefinition.getSubject();
            if (textStr == null || textStr.length() < 1) {
                this.appendTextLine(VWResource.s_colon.toString(VWResource.s_subject) + VWResource.s_none, 0, false);
            } else {
                this.appendTextLine(VWResource.s_colon.toString(VWResource.s_subject) + textStr, 0, false);
            }
        }
        this.newPrintSection();
        textStr = this.m_wfDefinition.getDescription();
        if (textStr == null || textStr.length() < 1) {
            this.appendTextLine(VWResource.s_descriptionColon + " " + VWResource.s_none, 0, false);
        } else {
            this.appendTextLine(VWResource.s_descriptionColon, 0, false);
            StringTokenizer st = new StringTokenizer(textStr, "\n");
            while (st.hasMoreTokens()) {
                this.appendTextLine(st.nextToken(), 1, true);
            }
        }
        if (this.m_bPrintAllInfo) {
            this.newPrintSection();
            this.appendTextLine(VWResource.s_colon.toString(VWResource.s_deadline), 0, false);
            long seconds = this.m_wfDefinition.getDeadline();
            textStr = seconds <= 0L ? VWResource.s_colon.toString(VWResource.s_deadlineWithin) + VWResource.s_none : VWResource.s_colon.toString(VWResource.s_deadlineWithin) + this.convertTime(seconds);
            this.appendTextLine(textStr, 1, true);
            long reminder = this.m_wfDefinition.getReminder();
            textStr = reminder <= 0L ? VWResource.s_colon.toString(VWResource.s_sendReminderBeforeDeadline) + VWResource.s_none : VWResource.s_colon.toString(VWResource.s_sendReminderBeforeDeadline) + this.convertTime(reminder);
            this.appendTextLine(textStr, 1, true);
            this.newPrintSection();
            textStr = this.m_wfDefinition.getRosterName();
            if (textStr == null || textStr.length() < 1) {
                textStr = VWResource.s_defaultRoster;
            }
            this.appendTextLine(VWResource.s_colon.toString(VWResource.s_roster) + textStr, 0, false);
            textStr = this.m_wfDefinition.getEventLogName();
            if (textStr == null || textStr.length() < 1) {
                textStr = VWResource.s_defaultEventLog;
            }
            this.appendTextLine(VWResource.s_colon.toString(VWResource.s_eventLog) + textStr, 0, false);
            textStr = this.m_wfDefinition.getTag();
            if (textStr == null || textStr.length() < 1) {
                this.appendTextLine(VWResource.s_colon.toString(VWResource.s_conditionIdentifier) + VWResource.s_none, 0, false);
            } else {
                this.appendTextLine(VWResource.s_colon.toString(VWResource.s_conditionIdentifier) + textStr, 0, false);
            }
            this.newPrintSection();
            textStr = this.m_wfDefinition.getDisableEmailNotification() ? VWResource.s_no : VWResource.s_yes;
            this.appendTextLine(VWResource.s_colon.toString(VWResource.s_enableEmailNotification) + textStr, 0, false);
            textStr = this.m_wfDefinition.getTransferFlag() ? VWResource.s_no : VWResource.s_yes;
            this.appendTextLine(VWResource.s_colon.toString(VWResource.s_transferFlag) + textStr, 0, false);
            textStr = this.m_wfDefinition.getValidateFlag() ? VWResource.s_no : VWResource.s_yes;
            this.appendTextLine(VWResource.s_colon.toString(VWResource.s_validateFlag) + textStr, 0, false);
            this.newPrintSection();
            VWRuleSetDefinition[] rules = this.m_wfDefinition.getRuleSets();
            if (rules != null && rules.length > 0) {
                this.appendTextLine(VWResource.s_colon.toString(VWResource.s_rules), 0, false);
                for (int ix = 0; ix < rules.length; ++ix) {
                    this.appendTextLine(Integer.toString(ix + 1) + ". " + rules[ix].getName(), 1, false);
                }
            } else {
                this.appendTextLine(VWResource.s_colon.toString(VWResource.s_rules) + VWResource.s_none, 0, false);
            }
        }
    }

    private void printFieldsInfo() throws Exception {
        boolean bHasDataField = false;
        this.newPrintSection();
        if (this.m_fields != null) {
            String strText = null;
            int ix = 0;
            for (int i = 0; i < this.m_fields.length; ++i) {
                int fieldType = this.m_fields[i].getFieldType();
                if (fieldType == 64 || fieldType == 32 || fieldType == 128) continue;
                ++ix;
                if (!bHasDataField) {
                    bHasDataField = true;
                    this.appendTextLine(VWResource.s_field + " ", 0, false);
                }
                this.appendTextLine(Integer.toString(ix) + ". " + this.m_fields[i].getName(), 1, false);
                this.appendTextLine(VWResource.s_typeLabel + " " + VWFieldType.getLocalizedString(fieldType), 2, false);
                this.appendTextLine(VWResource.s_colon.toString(VWResource.s_mergeType) + VWMergeType.getLocalizedString(this.m_fields[i].getMergeType()), 2, false);
                if (this.m_fields[i].isArray()) {
                    this.appendTextLine(VWResource.s_colon.toString(VWResource.s_array) + VWResource.s_true, 2, false);
                } else {
                    this.appendTextLine(VWResource.s_colon.toString(VWResource.s_array) + VWResource.s_false, 2, false);
                }
                strText = this.m_fields[i].getStringValue();
                if (strText == null || strText.length() < 1) {
                    this.appendTextLine(VWResource.s_colon.toString(VWResource.s_value) + VWResource.s_nullValue, 2, true);
                } else {
                    this.appendTextLine(VWResource.s_colon.toString(VWResource.s_value) + strText, 2, true, true);
                }
                strText = this.m_fields[i].getDescription();
                if (strText == null || strText.length() < 1) {
                    this.appendTextLine(VWResource.s_descriptionColon + " " + VWResource.s_none, 2, true);
                    continue;
                }
                this.appendTextLine(VWResource.s_descriptionColon + " " + strText, 2, true, true);
            }
        }
        if (!bHasDataField) {
            this.appendTextLine(VWResource.s_field + " " + VWResource.s_none, 0, false);
        }
    }

    private void printAttachmentsInfo() {
        boolean bHasAttachment = false;
        String strText = null;
        String mainAttName = null;
        this.newPrintSection();
        strText = this.m_wfDefinition.getMainAttachmentName();
        if (strText != null && strText.length() > 2) {
            mainAttName = strText.substring(1, strText.length() - 1);
        }
        if (this.m_fields != null && this.m_fields.length > 0) {
            int ix = 0;
            for (int i = 0; i < this.m_fields.length; ++i) {
                if (this.m_fields[i].getFieldType() != 32) continue;
                ++ix;
                if (!bHasAttachment) {
                    bHasAttachment = true;
                    this.appendTextLine(VWResource.s_colon.toString(VWResource.s_attachmentProperties), 0, false);
                }
                String attName = this.m_fields[i].getName();
                if (mainAttName != null && VWStringUtils.compare(attName, mainAttName) == 0) {
                    attName = attName + "  (" + VWResource.s_initAttachment + ")";
                }
                this.appendTextLine(Integer.toString(ix) + ". " + attName, 1, false);
                String strDesc = this.m_fields[i].getDescription();
                if (strDesc == null || strDesc.length() < 1) {
                    this.appendTextLine(VWResource.s_colon.toString(VWResource.s_description) + VWResource.s_none, 2, true);
                } else {
                    this.appendTextLine(VWResource.s_colon.toString(VWResource.s_description) + strDesc, 2, true, true);
                }
                if (this.m_fields[i].isArray()) {
                    this.appendTextLine(VWResource.s_colon.toString(VWResource.s_array) + VWResource.s_true, 2, false);
                    VWAttachment[] attachmentList = (VWAttachment[])this.m_fields[i].getValue();
                    for (int k = 0; k < attachmentList.length; ++k) {
                        String seq = Integer.toString(ix) + "." + Integer.toString(k + 1);
                        this.printAttachmentProperty(this.m_fields[i], attachmentList[k], seq);
                    }
                    continue;
                }
                this.appendTextLine(VWResource.s_colon.toString(VWResource.s_array) + VWResource.s_false, 2, false);
                VWAttachment attachment = (VWAttachment)this.m_fields[i].getValue();
                this.printAttachmentProperty(this.m_fields[i], attachment, null);
            }
        }
        if (!bHasAttachment) {
            this.appendTextLine(VWResource.s_colon.toString(VWResource.s_attachmentProperties) + VWResource.s_none, 0, false);
        }
    }

    private void printAttachmentProperty(VWFieldDefinition fieldDef, VWAttachment attachment, String idx) {
        try {
            int nIdentLevel = 2;
            boolean bUnassigned = false;
            if (attachment == null || attachment.getType() == 0) {
                bUnassigned = true;
            }
            if (idx != null && idx.length() > 0) {
                if (bUnassigned) {
                    this.appendTextLine(idx + " " + VWResource.s_unassigned, nIdentLevel, false);
                    return;
                }
                String attName = attachment.getType() == 5 ? attachment.getId() : attachment.getAttachmentName();
                this.appendTextLine(idx + " " + VWResource.s_colon.toString(attName), nIdentLevel, true);
                ++nIdentLevel;
            } else if (bUnassigned) {
                this.appendTextLine(VWResource.s_colon.toString(VWResource.s_value) + VWResource.s_unassigned, nIdentLevel, false);
                return;
            }
            this.appendTextLine(VWResource.s_colon.toString(VWResource.s_type) + VWAttachmentType.getLocalizedString(attachment.getType()), nIdentLevel, false);
            if (attachment.getType() != 5) {
                this.appendTextLine(VWResource.s_colon.toString(VWResource.s_id) + attachment.getId(), nIdentLevel, false);
            }
            switch (attachment.getType()) {
                case 3: 
                case 4: {
                    this.appendTextLine(VWResource.s_colon.toString(VWResource.s_repository) + attachment.getLibraryName(), nIdentLevel, false);
                    this.appendTextLine(VWResource.s_colon.toString(VWResource.s_repositoryType) + VWLibraryType.getLocalizedString(attachment.getLibraryType()), nIdentLevel, false);
                    String strVersion = attachment.getVersion();
                    if (strVersion == null) {
                        strVersion = VWResource.s_current;
                    } else if (VWStringUtils.compare(strVersion, "-1") == 0) {
                        strVersion = VWResource.s_released;
                    }
                    this.appendTextLine(VWResource.s_colon.toString(VWResource.s_version) + strVersion, nIdentLevel, false);
                    break;
                }
                case 1: 
                case 2: {
                    this.appendTextLine(VWResource.s_colon.toString(VWResource.s_repository) + attachment.getLibraryName(), nIdentLevel, false);
                    this.appendTextLine(VWResource.s_colon.toString(VWResource.s_repositoryType) + VWLibraryType.getLocalizedString(attachment.getLibraryType()), nIdentLevel, false);
                    break;
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void printWorkflowGroupInfo() {
        boolean bHasWFGroup = false;
        this.newPrintSection();
        if (this.m_fields != null && this.m_fields.length > 0) {
            int ix = 0;
            int fsz = this.m_fields.length;
            for (int i = 0; i < fsz; ++i) {
                if (this.m_fields[i].getFieldType() != 64) continue;
                ++ix;
                if (!bHasWFGroup) {
                    bHasWFGroup = true;
                    this.appendTextLine(VWResource.s_colon.toString(VWResource.s_workflowGroup), 0, false);
                }
                this.appendTextLine(Integer.toString(ix) + ". " + this.m_fields[i].getName(), 1, false);
                String groupDesc = this.m_fields[i].getDescription();
                if (groupDesc == null || groupDesc.length() <= 0) {
                    groupDesc = VWResource.s_none;
                }
                this.appendTextLine(VWResource.s_colon.toString(VWResource.s_description) + groupDesc, 2, true, true);
                VWParticipant[] participants = (VWParticipant[])this.m_fields[i].getValue();
                String sParticipants = null;
                if (participants != null && participants.length > 0) {
                    int psz = participants.length;
                    for (int j = 0; j < psz; ++j) {
                        if (participants[j] == null) continue;
                        sParticipants = sParticipants == null ? participants[j].getParticipantName() : sParticipants + ", " + participants[j].getParticipantName();
                    }
                    if (sParticipants == null) {
                        this.appendTextLine(VWResource.s_colon.toString(VWResource.s_participant) + VWResource.s_none, 2, false);
                        continue;
                    }
                    this.appendTextLine(VWResource.s_colon.toString(VWResource.s_participant), 2, false);
                    this.appendTextLine(sParticipants, 3, true);
                    continue;
                }
                this.appendTextLine(VWResource.s_colon.toString(VWResource.s_participant) + VWResource.s_none, 2, false);
            }
        }
        if (!bHasWFGroup) {
            this.appendTextLine(VWResource.s_colon.toString(VWResource.s_workflowGroup) + VWResource.s_none, 0, false);
        }
    }

    private void printMilestoneInfo() throws Exception {
        this.newPrintSection();
        if (this.m_milestones == null || this.m_milestones.length < 1) {
            this.appendTextLine(VWResource.s_colon.toString(VWResource.s_milestone) + VWResource.s_none, 0, false);
        } else {
            this.appendTextLine(VWResource.s_colon.toString(VWResource.s_milestone), 0, false);
            String strText = null;
            for (int i = 0; i < this.m_milestones.length; ++i) {
                strText = Integer.toString(i + 1) + ". " + this.m_milestones[i].getName() + "  (" + VWResource.s_colon.toString(VWResource.s_level) + this.m_milestones[i].getLevel() + ")";
                this.appendTextLine(strText, 1, false);
                this.appendTextLine(VWResource.s_colon.toString(VWResource.s_message) + this.m_milestones[i].getMessage(), 2, true, true);
            }
        }
    }

    private void printSubMapInfo() throws Exception {
        String aLine = null;
        this.newPrintSection();
        if (this.m_maps == null || this.m_maps.length < 1) {
            this.appendTextLine(VWResource.s_submaps + " " + VWResource.s_none, 0, false);
        } else {
            this.appendTextLine(VWResource.s_colon.toString(VWResource.s_submaps), 0, false);
            for (int i = 0; i < this.m_maps.length; ++i) {
                this.appendTextLine(Integer.toString(i + 1) + ". " + this.m_maps[i].getName(), 1, false);
                aLine = this.m_maps[i].getDescription();
                if (aLine != null && aLine.length() > 0) {
                    this.appendTextLine(VWResource.s_colon.toString(VWResource.s_description) + aLine, 2, true, true);
                    continue;
                }
                this.appendTextLine(VWResource.s_colon.toString(VWResource.s_description) + VWResource.s_none, 2, true, true);
            }
        }
    }

    private void printWebServicesInfo() throws Exception {
        String text = null;
        this.newPrintSection();
        text = this.m_wfDefinition.getIncomingWSAttachmentFolder();
        try {
            VWAttachment attachment = new VWAttachment(text);
            this.appendTextLine(VWResource.s_colon.toString(VWResource.s_incomingWSAttachmentFolder) + (attachment.getAttachmentName() != null ? attachment.getAttachmentName() : VWResource.s_none), 0, false);
        }
        catch (Exception ex) {
            // empty catch block
        }
        text = this.m_wfDefinition.getVersionAgnostic() ? VWResource.s_yes : VWResource.s_no;
        this.appendTextLine(VWResource.s_colon.toString(VWResource.s_showLatestRevision) + text, 0, false);
        text = this.m_wfDefinition.getValidateUsingSchema() ? VWResource.s_yes : VWResource.s_no;
        this.appendTextLine(VWResource.s_colon.toString(VWResource.s_validateUsingSchema) + text, 0, false);
        this.newPrintSection();
        VWPartnerLinkDefinition[] partnerLinks = this.m_wfDefinition.getPartnerLinks();
        if (partnerLinks != null) {
            int partnerLinkCount = partnerLinks.length;
            if (partnerLinkCount > 0) {
                this.appendTextLine(VWResource.s_colon.toString(VWResource.s_partnerLinks), 0, false);
                for (int i = 0; i < partnerLinkCount; ++i) {
                    VWPartnerLinkDefinition partnerLink = partnerLinks[i];
                    this.appendTextLine(i + 1 + ". " + partnerLink.getName() + " (" + this.getType(partnerLink) + ")", 1, false);
                    text = partnerLink.getPartnerEndPoint();
                    this.appendTextLine(VWResource.s_colon.toString(VWResource.s_wsdlURL) + (text != null && text.length() > 0 ? text : VWResource.s_none), 2, true);
                    text = partnerLink.getPartnerPortType();
                    this.appendTextLine(VWResource.s_colon.toString(VWResource.s_portType) + (text != null && text.length() > 0 ? text : VWResource.s_none), 2, true);
                    text = partnerLink.getPartnerRole();
                    this.appendTextLine(VWResource.s_colon.toString(VWResource.s_role) + (text != null && text.length() > 0 ? text : VWResource.s_none), 2, true);
                    text = partnerLink.getMyPortType();
                    this.appendTextLine(VWResource.s_colon.toString(VWResource.s_processPortType) + (text != null && text.length() > 0 ? text : VWResource.s_none), 2, true);
                    text = partnerLink.getMyRole();
                    this.appendTextLine(VWResource.s_colon.toString(VWResource.s_processRole) + (text != null && text.length() > 0 ? text : VWResource.s_none), 2, true);
                    text = partnerLink.getWSDLRef();
                    this.appendTextLine(VWResource.s_colon.toString(VWResource.s_partnerWsdlRef) + (text != null && text.length() > 0 ? text : VWResource.s_none), 2, true);
                }
            } else {
                this.appendTextLine(VWResource.s_colon.toString(VWResource.s_partnerLinks) + VWResource.s_none, 0, false);
            }
        } else {
            this.appendTextLine(VWResource.s_colon.toString(VWResource.s_partnerLinks) + VWResource.s_none, 0, false);
        }
        this.newPrintSection();
        VWSchema[] schemas = this.m_wfDefinition.getSchemas();
        if (schemas != null) {
            int schemaCount = schemas.length;
            if (schemaCount > 0) {
                this.appendTextLine(VWResource.s_colon.toString(VWResource.s_xmlSchema), 0, false);
                for (int i = 0; i < schemaCount; ++i) {
                    VWSchema schema = schemas[i];
                    this.appendTextLine(i + 1 + ". " + schema.getName(), 1, false);
                    text = schema.getSchema();
                    this.appendTextLine(text != null && text.length() > 0 ? text : VWResource.s_none, 2, true);
                }
            } else {
                this.appendTextLine(VWResource.s_colon.toString(VWResource.s_xmlSchema) + VWResource.s_none, 0, false);
            }
        } else {
            this.appendTextLine(VWResource.s_colon.toString(VWResource.s_xmlSchema) + VWResource.s_none, 0, false);
        }
        this.newPrintSection();
        VWFieldDefinition[] fields = this.m_wfDefinition.getFields();
        if (fields != null) {
            int fieldCount = fields.length;
            if (fieldCount > 0) {
                int xmlDataFieldCount = 0;
                for (int i = 0; i < fieldCount; ++i) {
                    VWFieldDefinition field = fields[i];
                    int fieldType = field.getFieldType();
                    if (fieldType != 128) continue;
                    if (xmlDataFieldCount == 0) {
                        this.appendTextLine(VWResource.s_colon.toString(VWResource.s_xmlDataFields), 0, false);
                    }
                    this.appendTextLine(++xmlDataFieldCount + ". " + field.getName(), 1, false);
                    text = field.getXMLSchemaName();
                    this.appendTextLine(VWResource.s_colon.toString(VWResource.s_xmlSchema) + (text != null && text.length() > 0 ? text : VWResource.s_none), 2, true);
                    text = field.getXMLSchemaElement();
                    this.appendTextLine(VWResource.s_colon.toString(VWResource.s_xmlSchemaElement) + (text != null && text.length() > 0 ? text : VWResource.s_none), 2, true);
                    text = VWMergeType.getLocalizedString(field.getMergeType());
                    this.appendTextLine(VWResource.s_colon.toString(VWResource.s_mergeType) + (text != null && text.length() > 0 ? text : VWResource.s_none), 2, true);
                    text = field.getValue().toString();
                    this.appendTextLine(VWResource.s_colon.toString(VWResource.s_value) + (text != null && text.length() > 0 ? text : VWResource.s_none), 2, true);
                    text = field.getDescription();
                    this.appendTextLine(VWResource.s_colon.toString(VWResource.s_description) + (text != null && text.length() > 0 ? text : VWResource.s_none), 2, true);
                }
            } else {
                this.appendTextLine(VWResource.s_colon.toString(VWResource.s_xmlDataFields) + VWResource.s_none, 0, false);
            }
        } else {
            this.appendTextLine(VWResource.s_colon.toString(VWResource.s_xmlDataFields) + VWResource.s_none, 0, false);
        }
    }

    private String getType(VWPartnerLinkDefinition partnerLinkDef) {
        String type = VWResource.s_unknown;
        String wsdlUrl = null;
        String processPortType = null;
        String processRole = null;
        if (partnerLinkDef != null) {
            wsdlUrl = partnerLinkDef.getPartnerEndPoint();
            processPortType = partnerLinkDef.getMyPortType();
            processRole = partnerLinkDef.getMyRole();
            if (wsdlUrl == null && processPortType != null && processRole != null) {
                type = VWResource.s_receiveReply;
            } else if (wsdlUrl != null && processPortType == null && processRole == null) {
                type = VWResource.s_invoke;
            } else if (wsdlUrl != null && processPortType != null && processRole != null) {
                type = VWResource.s_both;
            }
        }
        return type;
    }
}

